<?php
/* 
Plugin Name: PrivateContent - Mail Actions Add-on 
Plugin URI: http://www.lcweb.it/privatecontent/mail-actions-add-on
Description: Manages PrivateContent e-mail operations: e-mail address validation, password retrieval, Mailchimp sync and much more. Finally a true e-mail marketing campaign engine to run your newsletters!
Author: Luca Montanari (LCweb)
Author URI: https://lcweb.it
Version: 2.3.2
Requires at least: 5.0
Requires PHP: 5.4
*/  



/////////////////////////////////////////////
/////// MAIN DEFINES ////////////////////////
/////////////////////////////////////////////

// plugin path
$wp_plugin_dir = substr(plugin_dir_path(__FILE__), 0, -1);
define( 'PCMA_DIR', $wp_plugin_dir );

// plugin url
$wp_plugin_url = substr(plugin_dir_url(__FILE__), 0, -1);
define( 'PCMA_URL', $wp_plugin_url );


// add-on version
define('PCMA_VER', '2.3.2');

// multilanguage id
define('PCMA_ML', 'pcma_ml');






///////////////////////////////////////////////
/////// CHECK IF PRIVATECONTENT IS ACTIVE /////
///////////////////////////////////////////////

include_once(ABSPATH .'wp-admin/includes/plugin.php');
if(!is_plugin_active('private-content/private_content.php') && !defined('PC_VERS')) {
    
	function pcma_no_plugin_warning() {
		echo '
		<div class="error">
		   <p>'. __('Please activate PrivateContent plugin to use the "Mail Actions" add-on', PCMA_ML) .'</p>
		</div>';
	}
	add_action('admin_notices', 'pcma_no_plugin_warning');
}


else {
	
	/////////////////////////////////////////////
	/////// MULTILANGUAGE SUPPORT ///////////////
	/////////////////////////////////////////////
	
	function pcma_multilanguage() {
		$param_array = explode(DIRECTORY_SEPARATOR, PCMA_DIR);
		$folder_name = end($param_array);
	  	
		if(is_admin()) {
		   load_plugin_textdomain(PCMA_ML, false, $folder_name . '/lang_admin');  
		}
		load_plugin_textdomain(PCMA_ML, false, $folder_name . '/languages'); 
	}
	add_action('init', 'pcma_multilanguage', 1);
	
	
	
	//////////////////////////////////
	// SCRIPT ENQUEUING
	function pcma_scripts() { 
		
        if(!is_admin()) {
			wp_enqueue_script('pcma_fontend_js', PCMA_URL .'/js/private-content-ma.min.js', array('jquery', 'pc_frontend'), PCMA_VER, true);	
		}
        
		else {
            global $current_screen;
            if(!$current_screen) {
                return;    
            }
            
			wp_enqueue_style('pcma_admin', PCMA_URL . '/css/admin.css', 800, PCMA_VER);
             
            
            // settings page scripts
            if(is_object($current_screen) && $current_screen->base == 'pvtcont-add-ons_page_pcma_settings') {
                $baseurl = PC_URL .'/js';
                wp_enqueue_style('pc_settings', PC_URL .'/settings/settings_style.css', 999, PC_VERS);	

                wp_enqueue_style('codemirror',          $baseurl .'/codemirror/codemirror.css');
                wp_enqueue_script('codemirror',         $baseurl .'/codemirror/codemirror.min.js', 200, '1.0', true);
                wp_enqueue_script('codemirror-lang-css',$baseurl .'/codemirror/languages/css.min.js', 201, '1.0', true);
            }
            
            
            // emoji picker and autocomplete in settings and campaign builder
            if(is_object($current_screen) && ($current_screen->base == 'pvtcont-add-ons_page_pcma_settings' || $current_screen->id == "pcma_email_campaigns")) {
                
                wp_enqueue_script('jquery-ui-autocomplete');
                wp_enqueue_script('lc-emoji-picker', PCMA_URL .'/js/lc-emoji-picker/lc_emoji_picker.min.js', 300, '1.1.2', true);
            }
		}
	}
	add_action('wp_enqueue_scripts', 'pcma_scripts');
	add_action('admin_enqueue_scripts', 'pcma_scripts');
	
	
	
	
	////////////////////////////////////////////////////////
	
	
    
	
	// UTILITY FUNCTIONS
	include_once(PCMA_DIR . '/helpers.php');
	
	// TEMPLATES TAXONOMY
	include_once(PCMA_DIR . '/mail_templates_pt.php');
	
    // E-MAIL CAMPAIGNS
	include_once(PCMA_DIR . '/classes/email_campaigns.php');
    
    // E-MAIL CAMPAIGNS - POSTS LIST TWEAKS
	include_once(PCMA_DIR . '/email_campaigns_list.php');
    
    // E-MAIL CAMPAIGNS - BUILDER INTERFACE
	include_once(PCMA_DIR . '/email_campaigns_builder.php');
    
	// INTEGRATIONS
	include_once(PCMA_DIR . '/integrations.php');
    
    // USER PVT PAGE UPDAATE NOTIFIER
	include_once(PCMA_DIR . '/classes/user_pp_update_notif.php');
    
    // MISC MAILS DISPATCHERS
	include_once(PCMA_DIR . '/mail_dispatchers.php');
    
	
	// MAILCHIMP IMPLEMENTATION THROUGH HOOKS
	include_once(PCMA_DIR . '/classes/mailchimp_integration.php');
	
	// PUBLIC API
	include_once(PCMA_DIR . '/public_api.php');
	
	// ADMIN AJAX
	include_once(PCMA_DIR . '/admin_ajax.php');
	
	// PSW RECOVERY
	include_once(PCMA_DIR . '/classes/psw_recovery.php');
    
    // USER MAIL VERIFICATION
	include_once(PCMA_DIR . '/classes/mail_verif.php');
	
	// TINYMCE EMOJI PICKER AND MAIL PREVIEW
	include_once(PCMA_DIR . '/tinymce_emoji_n_preview.php');
	
	// USER ACTIVITIES ADD-ON INTEGRATION
	include_once(PCMA_DIR . '/pcua_integration.php');
    
    
	
    
    ////////////
    // DIKE WP DASHBOARD

    $pcma_dike_slug = (isset($GLOBALS['is_pc_bundle'])) ? 'pcbp' : 'pcma';
    define('PCMA_DIKE_SLUG', $pcma_dike_slug);
    
    function pcma_dike_updater_data($data) {
        $data['pcma'] = array(
            'callback' => 'pcma_on_activation',
            'no_files_del' => false,
        );
        return $data;
    }
    add_filter('dike_lcweb_updater', 'pcma_dike_updater_data');
    
    ////////////
}






//////////////////////////////////////////////////
// ACTIONS ON PLUGIN ACTIVATION //////////////////
//////////////////////////////////////////////////

function pcma_on_activation() {
	
	// mailchimp - setup meta for subscription status
	if(!get_option('pcma_v1.5_mc_meta')) {
		global $pc_users, $wpdb;
		
		$result = $pc_users->get_users(
			array(
				'limit' => -1,	
				'to_get' => 'id'
		  	)
		); 
		
		foreach($result as $user) { 
			if(!(int)$user['id']) {
                continue;
            }
			
			$wpdb->insert( 
				$wpdb->prefix . "pc_user_meta", 
				array(
					'user_id' 	=> $user['id'],
					'meta_key' 	=> 'pcma_mc_disclaimer',
					'meta_value'=> 1
				)
			);	
		}	
		update_option('pcma_v1.5_mc_meta', 1);
	}
	
	
	// v1.6 - stop using nl2br but update existing settings for retrocompatibility
	if(!get_option('pcma_v1.6_nl2br')) {
		$opts = array('pcma_mv_txt', 'pcma_nnu_txt', 'pcma_nau_txt', 'pcma_wm_txt', 'pcma_niu_txt', 'pcma_psw_mail_txt', 'pcud_sfan_receivers');
		
		foreach($opts as $opt) {
			$val = get_option($opt); 
			if($val && is_string($val)) {
				update_option($opt, nl2br($val)); 
			}
		}
	}
    
    
    // v2.1 - update fixed hourly outgoing email limit to val + period
    if(!get_option('pcma_bulk_mail_limit_num')) {
        update_option('pcma_bulk_mail_limit_num', get_option('pcma_emails_per_hour', 400));
        update_option('pcma_bulk_mail_limit_type', 'hourly');
    }
    
    
    // inject styles
    if(class_exists('pc_static') && method_exists('pc_static', 'create_custom_style')) {
        pc_static::create_custom_style();
    }
}
register_activation_hook(__FILE__, 'pcma_on_activation');





// REQUIRE RIGHT CORE PLUGIN VERSION
function pcma_requirements_check() {
	$req_v = '8.10.2';
    
    if(!defined('PC_VERS') || version_compare(PC_VERS, $req_v, '<')) {
		deactivate_plugins( plugin_basename( __FILE__ ) );
        
        $btn = '<br/><a href="'. esc_attr(network_admin_url('plugins.php')) .'">'. esc_html__('Return to plugins page', PCMA_ML) .'</a>';
		wp_die('Mail Actions add-on '. __('requires at least', PCMA_ML) .' PrivateContent v'. $req_v .' '. __('installed', PCMA_ML) .'!'. $btn);
	}
}
register_activation_hook(__FILE__, 'pcma_requirements_check');
add_action('admin_init', 'pcma_requirements_check', 1);





//////////////////////////////////////////////////
// REMOVE WP HELPER FROM PLUGIN PAGES

function pcma_remove_wp_helper() {
	$cs = get_current_screen();
	$hooked = array('privatecontent_page_pcma_settings');
	
	if(is_object($cs) && in_array($cs->base, $hooked)) {
		echo '
		<style type="text/css">
		#screen-meta-links {display: none;}
		</style>';	
	}
}
add_action('admin_head', 'pcma_remove_wp_helper', 999);
